uniform sampler2D reflectionmap;
uniform sampler2D refractionmap;
uniform sampler2D water_Normalmap;
uniform mat3 core_ModelViewNormalMatrix;

uniform float reflection_CancelUnderWater;
uniform float reflection_CancelAboveWater;

varying vec4 projCoord;
varying vec4 refractCoord;
varying vec2 texCoord1;
varying vec2 texCoord2;
varying vec3 viewdir;

varying float distance;

void main()
{
	if(reflection_CancelUnderWater == 1.0 || reflection_CancelAboveWater == 1.0)
	{
		discard;
	}

	vec3 normal = normalize((texture2D(water_Normalmap,texCoord1).xyz*2.0 - 1.0) + (texture2D(water_Normalmap,texCoord2).xyz*2.0 - 1.0));
	vec3 wave = normal- vec3(0,0,1);
	normal = normalize(core_ModelViewNormalMatrix * normal);
	vec3 frag_viewdir = normalize(viewdir);
	float seacolorfactor = abs(dot(normal,frag_viewdir));

	vec2 reflect_coord = (projCoord.xy/projCoord.w + 1.0) * 0.5 + wave.xy * 0.1;
	vec2 refract_coord = (refractCoord.xy/refractCoord.w + 1.0) * 0.5 + wave.xy * 0.1;
	vec4 reflectioncolor = texture2D(reflectionmap,reflect_coord);
	vec4 refractioncolor = texture2D(refractionmap,refract_coord);
	
	gl_FragColor = reflectioncolor * (1.0-seacolorfactor) + refractioncolor * seacolorfactor;
	gl_FragColor.a = distance;
}