varying vec2 texCoord1;
varying vec2 texCoord2;
varying vec2 texCoord;

uniform sampler2D grass;
uniform sampler2D rock;
uniform sampler2D rock_normalmap;
uniform sampler2D sand;
uniform sampler2D normalmap;
uniform sampler2D shadowmap;
uniform sampler2D water_Normalmap;

uniform float ambientfactor;
uniform float reflection_Height;
uniform float reflection_CancelAboveWater;
uniform float reflection_CancelUnderWater;
uniform vec4 shadow_Light1Direction;
varying float grey;
varying vec4 coord;
varying vec4 viewdir;

varying float worldHeight;

varying float distance;

float getShadowFactor(vec3 shadowcoord)
{
	vec2 varianceelement = (texture2D(shadowmap,shadowcoord.xy).rg) + vec2(0.01,0.01)*0.5;
	float moment1 = varianceelement.x;
	float moment2 = varianceelement.y;
	if(grey <= moment1)
	{
		return 1.0;
	}
	float variance = moment2 - moment1*moment1;
	float shadowlength = grey - moment1;
	float maxprobability = variance / (variance + shadowlength*shadowlength);

	return min(1.0,maxprobability)*(1.0-moment1*0.15);
}

vec4 getFragmentColor(vec4 color,float ambientfactor,float diffusefactor,float specularfactor,vec3 shadowcoord)
{
	float shadowfactor = getShadowFactor(shadowcoord);
	return max(max(color*diffusefactor*shadowfactor,color*ambientfactor),color*specularfactor*shadowfactor);
}

void main()
{
	if(reflection_CancelUnderWater == 1.0 && reflection_Height > worldHeight)
	{
		discard;
	}
	else if(reflection_CancelAboveWater == 1.0 && reflection_Height <= worldHeight)
	{
		discard;
	}
	vec3 light = normalize(-shadow_Light1Direction.xyz);
	vec3 shadowcoord = (coord.xyz/coord.w)*0.5 + vec3(0.5,0.5,0.5);
//	vec4 closestgrey = (vec4(texture2D(shadowmap,shadowcoord.xy).r)) + vec4(0.01,0.01,0.01,0.01)*0.5;
	vec3 vertexnormal = normalize(texture2D(normalmap,texCoord).rgb*2.0 - 1.0);
	vertexnormal.r = -vertexnormal.r;
	float gradient = 1.0 - dot(vertexnormal,vec3(0,0,1));
	float color1factor = 1.0;
	float color2factor = 0.0;
	float color3factor = 0.0;
	if(gradient>0.04)
	{
		color1factor = 0.0;
		color2factor = 1.0;
	}
	else if(gradient > 0.03)
	{
		color2factor = (gradient - 0.03)/(0.04-0.03);
		color1factor = 1.0 - color2factor;
	}
	if(worldHeight<= reflection_Height)
	{
		color1factor = 0.0;
		color2factor = 0.0;
		color3factor = 1.0;
	}
	else if(worldHeight < 1.0+reflection_Height)
	{
		color3factor = 1.0 - (worldHeight-reflection_Height);
		color1factor = color1factor*(1.0 - color3factor);
		color2factor = color2factor*(1.0 - color3factor);
	}
	vec4 terraincolor1 = vec4(0,0,0,0);
	vec4 terraincolor2 = vec4(0,0,0,0);
	vec3 normaldelta2 = vec3(0,0,0);
	vec3 normaldelta3 = vec3(0,0,0);
	float specular = 0.0;
	vec4 terraincolor3 = vec4(0,0,0,0);
	float diffuse3 = 1.0;
	if(color1factor != 0.0)
	{
		vec2 grasscoord = texCoord*100.0;
		grasscoord.y = mod(grasscoord.y*0.5,0.49)+0.005;
		vec4 grasscolor = texture2D(grass,grasscoord+vec2(0.0,0.5));
		if(distance < 70.0)
		{
			float distancefactor = (1.0-(distance/70.0));
			normaldelta3 = texture2D(grass,grasscoord).rgb;
			normaldelta3 = (normalize(normaldelta3*2.0-1.0)-vec3(0,0,1))*2.0*distancefactor;

			vec3 frag_viewdir = normalize(viewdir.xyz);
			vec3 currentnormal = normalize(vertexnormal+normaldelta3);
			diffuse3 = dot(currentnormal,light);
			currentnormal = normalize(vec3(vec2(vertexnormal.xy*/*10.0*/2.5),vertexnormal.z)+normaldelta3);
			vec3 refldir = normalize(2.0*currentnormal*diffuse3 - light.xyz);
			specular = dot(refldir,frag_viewdir);
			specular = min(pow(max(0.0 , specular*1.0) , 5.0)*distancefactor*color1factor,ambientfactor);
		}
		else
		{
			diffuse3 = dot(vertexnormal,light);
		}
		
		terraincolor1 = grasscolor;
	}
	
	if(color2factor != 0.0)
	{
		vec2 rockcoord1 = vec2(texCoord.x*20.0,worldHeight/255.0+texCoord.x)*5.0;
		vec2 rockcoord2 = vec2(texCoord.y*20.0,worldHeight/255.0+texCoord.y)*5.0;
		terraincolor2 = max(texture2D(rock,rockcoord1),texture2D(rock,rockcoord2));
		normaldelta2 = max(texture2D(rock_normalmap,rockcoord1),texture2D(rock_normalmap,rockcoord2)).rgb;
		
		normaldelta2 = (normalize(normaldelta2*2.0 - 1.0)-vec3(0,0,1))*2.0;
	}
	if(color3factor == 1.0)
	{
		vec3 frac = normalize((texture2D(water_Normalmap,texCoord1).xyz*2.0 - 1.0) + (texture2D(water_Normalmap,texCoord2).xyz*2.0 - 1.0));
		float f = dot(vec3(0,1,0),frac);
		terraincolor3 = vec4(texture2D(sand,texCoord*100.0).rgb +  vec3(f),0.0);
	}
	else if(color3factor != 0.0)
	{
		terraincolor3 = texture2D(sand,texCoord*100.0);
	}
	
	if(grey < 0.0 || shadowcoord.x <= 0.0 || shadowcoord.x >=1.0 || shadowcoord.y <= 0.0 || shadowcoord.y >= 1.0)
	{
		vec3 light = normalize(-shadow_Light1Direction.xyz);
		gl_FragColor = ambientfactor*(terraincolor1*color1factor + terraincolor2*color2factor + terraincolor3*color3factor)*max(ambientfactor*0.2,min(dot(normalize(vertexnormal+normaldelta2),light),diffuse3));
	}
	else
	{
		light = normalize(-shadow_Light1Direction.xyz);
		gl_FragColor = getFragmentColor(terraincolor1*color1factor + terraincolor2*color2factor + terraincolor3*color3factor,ambientfactor*0.2, max(ambientfactor*0.2,min(dot(normalize(vertexnormal+normaldelta2),light),diffuse3)),specular,shadowcoord);
	}
	gl_FragColor.a = distance;
	/*else if(closestgrey.z < grey)
	{
		gl_FragColor = gl_FragColor = (terraincolor1*color1factor + terraincolor2*color2factor + terraincolor3*color3factor)*ambientfactor*0.2;
	}
	else
	{
		gl_FragColor = (terraincolor1*color1factor + terraincolor2*color2factor + terraincolor3*color3factor)*max(ambientfactor*0.2,(dot(normalize(vertexnormal+normaldelta2),normalize(-shadow_Light1Direction.xyz))));
	}*/
}