uniform float reflection_CancelAboveWater;
uniform float reflection_CancelUnderWater;
uniform float reflection_Height;
uniform sampler2D skymap;
uniform vec4 shadow_Light1Direction;

varying float worldHeight;
varying vec3 skyposition;
varying float distance;

void main(void)
{
	if(reflection_CancelUnderWater == 1.0 && reflection_Height > worldHeight)
	{
		discard;
	}
	else if(reflection_CancelAboveWater == 1.0 && reflection_Height <= worldHeight)
	{
		discard;
	}
	
	vec3 normalizedlightdirection = normalize(-shadow_Light1Direction.xyz);
	float angle = dot(normalizedlightdirection,vec3(0,0,1));
	float daytime = 0.0;
	if(angle >= 0.0)
	{
		daytime = (8.0 - angle*8.0)/12.0;
	}
	else
	{
		daytime = (8.0 - angle*3.0)/12.0;
	}
	vec3 normalizedskyposition = normalize(skyposition);
	float skyheight = max(dot(normalizedskyposition,vec3(0,0,1)),0.0)*0.916666666;
	float sunmetric = max(dot(normalizedskyposition,normalizedlightdirection),0.0);
	float sunfactor = 0.0;
	float glowfactor = 0.0;
	float glowfactor2 = 0.0;
	if(sunmetric>0.99875)
	{
		sunfactor = 1.0;
	}
	else if(sunmetric>0.998)
	{
		sunfactor = (sunmetric - 0.998)*((1.0-0.8)/(0.99875-0.998)) + 0.8;
	}
	else if(sunmetric>0.995)
	{
		sunfactor = (sunmetric - 0.995)*(0.8/(0.998-0.995));
	}
	else
	{
		sunfactor = 0.0;
	}
	if(sunmetric>0.99875)
	{
		glowfactor =  pow((1.0-skyheight),3.0);
	}
	else if(sunmetric>0.8)
	{
		glowfactor = (sunmetric - 0.8)*(1.0/(0.99875-0.8)) * pow((1.0-skyheight),3.0);
	}
	else
	{
		glowfactor = 0.0;
	}
	if(sunmetric>0.99875)
	{
		glowfactor2 =  0.75*pow((1.0-skyheight),4.0);
	}
	else if(sunmetric>0.99)
	{
		glowfactor2 = (sunmetric - 0.99)*(0.75/(0.99875-0.99)) * pow((1.0-skyheight),4.0);
	}
	else
	{
		glowfactor2 = 0.0;
	}
	gl_FragColor = vec4(max(max(texture2D(skymap,vec2(daytime,skyheight)) , vec4(sunfactor,sunfactor,sunfactor,0)),vec4(glowfactor,glowfactor2 + 0.25*glowfactor,0,0)).rgb,distance);
}
