uniform sampler2D ringoffiretexture;
uniform sampler2D explosionbackground;

uniform float firefactor;
uniform float size;

varying vec2 pipe_coord0;
varying vec4 pos;
varying float worldHeight;

void main(void)
{
	vec2 lookup = ( (pos.xy/pos.w) + 1.0 ) * 0.5;
	float depth = texture2D(explosionbackground,lookup).a;
	vec3 color = texture2D(ringoffiretexture,pipe_coord0).rgb;
	float alpha = min(max(color.r,max(color.g,color.b)),(depth - pos.z)/50.0);
	gl_FragColor = vec4(color,firefactor*alpha);
}
