uniform sampler2D shadowmap;
uniform sampler2D texture;
uniform sampler2D normalmap;
uniform sampler2D heightmap;
uniform sampler2D water_Normalmap;

uniform vec4 shadow_Light1Direction;
uniform float ambientfactor;
uniform float reflection_Height;
uniform float reflection_CancelAboveWater;
uniform float reflection_CancelUnderWater;

varying float distance;

varying float grey;
varying vec3 shadowcoord;

varying vec3 pipe_lightdir;
varying vec3 pipe_view;
varying vec2 pipe_coord0;

varying vec2 texCoord1;
varying vec2 texCoord2;

varying float worldHeight;

float getShadowOfFragment(vec3 shadowcoord)
{
	vec4 closestgrey = (vec4(texture2D(shadowmap,shadowcoord.xy).r)) + vec4(0.01,0.01,0.01,0.01)*0.5;
	if(grey < 0.0 || grey > closestgrey.z || shadowcoord.x <= 0.0 || shadowcoord.x >=1.0 || shadowcoord.y <= 0.0 || shadowcoord.y >= 1.0)
	{
		return 0.0;
	}
	else
	{
		return 1.0;
	}
}

float getShadowPercentage(vec3 shadowcoord,float epsilon)
{
	float sum = 0.0;
	float kernelsize_x = 2.0;
	float kernelsize_y = 2.0;
	for(float i=0.0 ; i<kernelsize_x ; i++)
	{
		for(float j=0.0 ; j<kernelsize_y ; ++j)
		{
			sum += getShadowOfFragment(shadowcoord+vec3(epsilon,0.0,0.0)*(1.0-i)+vec3(0.0,epsilon,0.0)*(1.0-j));
		}
	}
	return sum/(kernelsize_x*kernelsize_y);
}

vec4 getFragmentColor(vec4 frag_color , float frag_diffuse , float frag_specular , vec3 shadowcoord)
{
	float shadowfactor = getShadowPercentage(shadowcoord,0.003);
	return max(max(vec4(0.1,0.1,0.1,1.0) * frag_color , (vec4(0.9,0.9,0.9,1.0) * frag_diffuse) * frag_color * shadowfactor ) , vec4(1.0,1.0,1.0,1.0) * frag_specular * shadowfactor) * ambientfactor;
}

void main(void)
{
	if(reflection_CancelUnderWater == 1.0 && reflection_Height > worldHeight)
	{
		discard;
	}
	else if(reflection_CancelAboveWater == 1.0 && reflection_Height <= worldHeight)
	{
		discard;
	}
	
	vec3 frag_lightdir = normalize(pipe_lightdir);
    vec3 frag_view = normalize(pipe_view);
    vec2 frag_oldcoord0 = pipe_coord0;
    float frag_parallaxfactor = (texture2D(heightmap,frag_oldcoord0).x * 5.0 - 2.0 ) * 0.002;
    vec2 frag_coord0 = frag_oldcoord0 + frag_parallaxfactor * frag_view.xy;
    vec3 frag_normal = normalize( texture2D(normalmap,frag_coord0).xyz * 2.0 - 1.0 );
    vec4 frag_color = texture2D(texture,frag_coord0);
    if(worldHeight<reflection_Height)
    {
		vec3 frac = normalize((texture2D(water_Normalmap,texCoord1).xyz*2.0 - 1.0) + (texture2D(water_Normalmap,texCoord2).xyz*2.0 - 1.0));
		float f1 = dot(vec3(0,1,0),normalize(frac+shadow_Light1Direction.xyz*0.2));
		float f2 = dot(vec3(0,1,0),frac);
		float f3 = dot(vec3(0,1,0),normalize(frac-shadow_Light1Direction.xyz*0.1));
		frag_color = frag_color + (max(vec4(0.0),vec4(f1,0,0,0)+vec4(0,f2,0,0)+vec4(0,0,f3,0))/3.0);
    }
   
    float frag_diffuse = dot(frag_normal , frag_lightdir);
   
    vec3 frag_reflection = frag_normal * frag_diffuse * 2.0 - frag_lightdir;
    float frag_specular = pow(max(0.0 , dot(frag_view , frag_reflection)) , 64.0);
	
	gl_FragColor = getFragmentColor(frag_color,frag_diffuse,frag_specular,shadowcoord);
	gl_FragColor.a = distance;
}
