uniform sampler2D screen;
uniform sampler2D vecolitymap;

varying vec2 pipe_coord0;

void main()
{
	vec2 vecolity = texture2D(vecolitymap,pipe_coord0).xy;
	vec2 vecolityboundary = vec2(1.0,1.0)*0.1;
	vecolity = min(max(vecolity,-vecolityboundary),vecolityboundary);
	vec4 vcolor = vec4(0.0);
	float vsamples = 10.0;
	vec2 deltavecolity = vecolity/(vsamples-1.0);
	vec2 currenttex = pipe_coord0;
	for(float i=0.0 ; i<vsamples ; ++i)
	{
		if(currenttex.x < 0.004)
		{
			currenttex.x = 0.004;
		}
		else if(currenttex.x > 0.996)
		{
			currenttex.x = 0.996;
		}
		if(currenttex.y < 0.004)
		{
			currenttex.y = 0.004;
		}
		else if(currenttex.y > 0.996)
		{
			currenttex.y = 0.996;
		}
		vcolor = vcolor + ( texture2D(screen,currenttex)/vsamples );
		currenttex = currenttex + deltavecolity;
	}
	
	gl_FragColor = vcolor;
}