uniform sampler2D explosiontexture;
uniform sampler2D explosionbackground;

uniform vec4 heatposition;
uniform float size;

uniform float firefactor;
uniform float reflection_CancelUnderWater;
uniform float reflection_CancelAboveWater;
uniform float reflection_Height;

varying vec2 pipe_coord0;
varying vec4 pos;
varying float worldHeight;

void main()
{
	if(reflection_CancelUnderWater == 1.0 && reflection_Height > worldHeight)
	{
		discard;
	}
	else if(reflection_CancelAboveWater == 1.0 && reflection_Height <= worldHeight)
	{
		discard;
	}
	
	vec4 color = texture2D(explosiontexture,pipe_coord0)*firefactor;
	color.a = min(color.r , min(color.g , color.b));

	vec2 lookup = ( (pos.xy/pos.w) + 1.0 ) * 0.5;
	float alpha = min((texture2D(explosionbackground,lookup).a - pos.z)/50.0,1.0);
	color = color * vec4(vec3(1.0),alpha);
	gl_FragColor = color;
}