uniform sampler2D screen;
uniform sampler2D vecolitymap;
uniform sampler2D wave;

uniform float kerneldelta;
uniform float isunderwater;
uniform float ambientfactor;
uniform float wave1;
uniform float wave2;
uniform float firefactor;
uniform float bloodyview;
uniform float gotliveview;

varying vec2 pipe_coord0;

void main()
{
	if(isunderwater == 0.0)
	{
		float d = texture2D(screen,pipe_coord0).a/255.0;
		float kd = kerneldelta * d;
		vec4 color = vec4(0.0,0.0,0.0,0.0);
	
		if(bloodyview > 0.0)
		{
			kd = kd * (max(bloodyview,gotliveview)*3.0+1.0);
		}
		color += texture2D(screen,pipe_coord0 + vec2(-kd,kd))*0.25 ; color += texture2D(screen,pipe_coord0 + vec2(kd,kd))*0.25 ;
		color += texture2D(screen,pipe_coord0 + vec2(-kd,-kd))*0.25 ; color += texture2D(screen,pipe_coord0 + vec2(kd,-kd))*0.25 ;
	
		if(bloodyview > 0.0)
		{
			color.g *= (1.0-bloodyview);
			color.b *= (1.0-bloodyview);
		}
		if(gotliveview > 0.0)
		{
			color *= (1.0+gotliveview);
		}
		if(firefactor == 0.0)
		{
			gl_FragColor = color;
		}
		else
		{
			float firedensity1 = exp(max((firefactor-0.75)*8.0,0.0))-1.0;
			float firedensity2 = exp(( max((firefactor - 0.875)*16.0,0.0) ))-1.0;
			vec4 mincolor = vec4(firedensity1);
			gl_FragColor = max(vec4(firedensity2*0.2),color*max(1.0,firedensity1));
		}
	}
	else
	{
		vec3 underwater = (texture2D(wave,pipe_coord0+vec2(wave1,wave2)).rgb*2.0 - 1.0);
		vec2 frag_coord0 = pipe_coord0 + underwater.xy*0.03;
		
		float d = texture2D(screen,frag_coord0).a/255.0;
		float kd = kerneldelta * d;
		if(bloodyview > 0.0)
		{
			kd = kd * (max(bloodyview,gotliveview)*3.0+1.0);
		}
		vec4 color = vec4(0.0,0.0,0.0,0.0);
	
		color += texture2D(screen,frag_coord0 + vec2(-kd,kd))*0.25 ; color += texture2D(screen,frag_coord0 + vec2(kd,kd))*0.25 ;
		color += texture2D(screen,frag_coord0 + vec2(-kd,-kd))*0.25 ; color += texture2D(screen,frag_coord0 + vec2(kd,-kd))*0.25 ;
		
		if(bloodyview > 0.0)
		{
			color.g *= (1.0-bloodyview);
			color.b *= (1.0-bloodyview);
		}
		if(gotliveview > 0.0)
		{
			color *= (1.0+gotliveview);
		}
		
		float nd = min(1.0,d*2.0);
		vec4 seacolor = vec4(0.325,0.4314,0.502,0.0)*ambientfactor;
		if(firefactor == 0.0)
		{
			gl_FragColor = (color*(1.0-nd) + seacolor*nd);
		}
		else
		{	
			float firedensity1 = exp(max((firefactor-0.75)*8.0,0.0))-1.0;
			float firedensity2 = exp(( max((firefactor - 0.875)*16.0,0.0) ))-1.0;
			vec4 mincolor = vec4(firedensity1);
			color = color*(1.0-nd) + seacolor*nd;
			gl_FragColor = max(vec4(firedensity2*0.2),color*max(1.0,firedensity1));
		}
	}
}
