uniform sampler2D crater;
uniform sampler2D craternormalmap;
uniform sampler2D terrain;
uniform sampler2D gradientmap;

uniform vec4 groundzero;
uniform float size;

varying vec2 pipe_coord0;

void main()
{
	vec2 crater_coord = (pipe_coord0 - groundzero.xy + vec2(size*0.5))/size;
	vec3 craternormal = (vec3(0.0,0.0,1.0)+1.0)*0.5;
	vec4 craterdepth = vec4(1.0);
	if(crater_coord.x >= 0.0 && crater_coord.x <= 1.0 && crater_coord.y >= 0.0 && crater_coord.y <= 1.0)
	{
		craternormal = texture2D(craternormalmap,crater_coord).rgb;
		craterdepth = texture2D(crater,crater_coord);
	}
	vec3 terrainnormal = texture2D(gradientmap,pipe_coord0).rgb;
	vec4 terraindepth = texture2D(terrain,pipe_coord0);
	if(terraindepth.r <= craterdepth.r)
	{
		gl_FragColor.rgb = terrainnormal;
	}
	else
	{
		gl_FragColor.rgb = craternormal;
	}
}