uniform sampler2D grass;
uniform sampler2D grass_alpha;
uniform sampler2D shadowmap;

uniform float ambientfactor;

uniform float reflection_Height;
uniform float reflection_CancelAboveWater;
uniform float reflection_CancelUnderWater;
uniform float disabletransparency;

varying vec3 pipe_normal;
varying vec2 pipe_texcoord;
varying vec3 pipe_lightdir;
varying vec3 pipe_shadowcoord;
varying float pipe_grey;
varying vec3 pipe_terrainnormal;

varying float pipe_worldHeight;

float getShadowOfFragment(vec3 shadowcoord)
{
	vec4 closestgrey = vec4((texture2D(shadowmap,shadowcoord.xy).r)) + vec4(0.01,0.01,0.01,0.01)*3.0;
	if(pipe_grey < 0.0 || pipe_grey > closestgrey.z || shadowcoord.x <= 0.0 || shadowcoord.x >=1.0 || shadowcoord.y <= 0.0 || shadowcoord.y >= 1.0)
	{
		return 0.0;
	}
	else
	{
		return 1.0;
	}
}

float getShadowPercentage(vec3 shadowcoord,float epsilon)
{
	float sum = 0.0;
	float kernelsize_x = 1.0;
	float kernelsize_y = 1.0;
	for(float i=0.0 ; i<kernelsize_x ; i++)
	{
		for(float j=0.0 ; j<kernelsize_y ; ++j)
		{
			sum += getShadowOfFragment(shadowcoord+vec3(epsilon,0.0,0.0)*(1.0-i)+vec3(0.0,epsilon,0.0)*(1.0-j));
		}
	}
	return sum/(kernelsize_x*kernelsize_y);
}

vec4 getFragmentColor(vec4 frag_color , float frag_diffuse , vec3 shadowcoord)
{
	float shadowfactor = getShadowPercentage(shadowcoord,0.003);
	return vec4(0.9,0.9,0.9,0.0) * frag_color * shadowfactor * ambientfactor;
}

void main()
{
	if(texture2D(grass_alpha,pipe_texcoord).r < 0.1 && !(disabletransparency > 0.0))
	{
		discard;
	}
	else if(reflection_CancelUnderWater == 1.0 && reflection_Height > pipe_worldHeight)
	{
		discard;
	}
	else if(reflection_CancelAboveWater == 1.0 && reflection_Height <= pipe_worldHeight)
	{
		discard;
	}
	
	vec3 frag_lightdir = normalize(pipe_lightdir);
    vec3 frag_normal = pipe_terrainnormal;
    float diffusefactor = dot(frag_lightdir,frag_normal);
	
	vec4 frag_color = texture2D(grass,pipe_texcoord);

	gl_FragColor = getFragmentColor(frag_color,diffusefactor,pipe_shadowcoord);
}
