uniform sampler2D dynamicRingsMap;
uniform vec2 dynamicRingsMapWH;

uniform float ripple_scale;

void main(void)
{

  /*
  float x_hp = sin(length(vec2(+uniform_xz_scale_inv+deltas.x, deltas.y)*ripple_freq) + slice_nr*-10.0);
float x_hm = sin(length(vec2(-uniform_xz_scale_inv+deltas.x, deltas.y)*ripple_freq) + slice_nr*-10.0);

float z_hp = sin(length(vec2(deltas.x, +uniform_xz_scale_inv+deltas.y)*ripple_freq) + slice_nr*-10.0);
  float z_hm = sin(length(vec2(deltas.x, -uniform_xz_scale_inv+deltas.y)*ripple_freq) + slice_nr*-10.0);
  */

  vec2 tc_dx = vec2(1.0/dynamicRingsMapWH.x, 0.0);
  vec2 tc_dz = vec2(0.0, 1.0/dynamicRingsMapWH.y);

  float x_hp = texture2D(dynamicRingsMap, gl_TexCoord[0].st+tc_dx).a;
  x_hp*=2.0*ripple_scale;
  x_hp-=ripple_scale;

  float x_hm = texture2D(dynamicRingsMap, gl_TexCoord[0].st-tc_dx).a;
  x_hm*=2.0*ripple_scale;
  x_hm-=ripple_scale;

  float z_hp = texture2D(dynamicRingsMap, gl_TexCoord[0].st+tc_dz).a;
  z_hp*=2.0*ripple_scale;
  z_hp-=ripple_scale;

  float z_hm = texture2D(dynamicRingsMap, gl_TexCoord[0].st-tc_dz).a;
  z_hm*=2.0*ripple_scale;
  z_hm-=ripple_scale;


  float x_hdiff = x_hp - x_hm;
  float z_hdiff = z_hp - z_hm;

  /*
  vec3 dx = vec3(2.0, x_hdiff, 0.0);
  vec3 dz = vec3(0.0, z_hdiff, 2.0);
  */

  //less dominant normal-influence from dynamic rings
  vec3 dx = vec3(4.0, x_hdiff, 0.0);
  vec3 dz = vec3(0.0, z_hdiff, 4.0);
  /*
  vec3 dx = vec3(3.0, x_hdiff, 0.0);
  vec3 dz = vec3(0.0, z_hdiff, 3.0);
  */

  /*
  vec3 dx = vec3(2.0, (x_hdiff)*ripple_scale*damp, 0.0);
  vec3 dz = vec3(0.0, (z_hdiff)*ripple_scale*damp, 2.0);
  */

  vec3 normal = normalize(cross(dz, dx));
  //  normal.xz = clamp(normal.xz, -0.9, 0.9);

  normal*=0.5;
  normal+=0.5;
  
  //  normal = clamp(normal, 0.0, 1.0);

  //gl_FragColor = vec4(normal.xyz, 1.0);

  float z = texture2D(dynamicRingsMap, gl_TexCoord[0].st).a;
  gl_FragColor = vec4(normal.xyz, z);




  //gl_FragColor=texture2D(dynamicRingsMap, gl_TexCoord[0].st);

  //  gl_FragColor=vec4(1.0, 0.0, 0.0, 1.0);



}
