//x ... d_focus
//y ... d_near
//z ... d_far
//w ... clamp_far
uniform vec4 dof_params; 

uniform int need_dof_alpha;

float ComputeDepthBlur(float depth)
{
  float f;

  if(depth < dof_params.x) // if(depth < d_focus)
    {
      // distance between near blur distance and
      // focal distance
      // map range to [-1, 0]

      // f = (depth - d_focus) / (d_focus - d_near);
      f = (depth - dof_params.x) / (dof_params.x - dof_params.y);
    }
  else
    {
      // distance between focal distance and
      // far blur distance
      // map range to [0, 1]

      // f = (depth - d_focus) / (d_far - d_focus);
      f = (depth - dof_params.x) / (dof_params.z - dof_params.x);

      // f = clamp(f, 0.0, clamp_far);
      f = clamp(f, 0.0, dof_params.w);
    }

  // scale and bias into [0, 1] range
  return (f * 0.5 + 0.5);
}


uniform samplerCube cubeMap;

//uniform sampler2D cubeMap;

//varying vec3 dir;
varying vec4 dir;

void main(void)
{
  //  gl_FragColor = textureCube(cubeMap, dir);

  //    dir.xyzw*=2.0;
  //gl_FragColor = textureCube(cubeMap, dir);

      gl_FragColor.rgb = textureCube(cubeMap, dir.xyz).rgb;

      

      if(need_dof_alpha==0)
	//
	gl_FragColor.a = 0.2;
	//	gl_FragColor.a = 0.1;
      else
	//gl_FragColor.a = ComputeDepthBlur(gl_TexCoord[4].q);
	//	gl_FragColor.a = 0.5;
	//	gl_FragColor.a = 0.6;
	//	gl_FragColor.a = 0.7;
	//	gl_FragColor.a = 0.75;
	//	gl_FragColor.a = 0.85;
	//
	gl_FragColor.a = 1.0;


}
