varying vec3 normal;
varying vec4 vertexPos;

varying vec4 height_diffs;

varying float ipoled_height;

varying vec4 ws_normal;


varying vec4 deltas;
varying vec2 deltac;

uniform vec2 waterDynamicWH;

uniform vec3 translate;
uniform float uniform_xz_scale_inv;

//void mainNEW(void)
void main(void)
{
  deltas = gl_MultiTexCoord0.stst - 0.5;
  deltac = gl_MultiTexCoord0.st - 0.5;
  gl_TexCoord[0] = gl_MultiTexCoord0;
  //  gl_TexCoord[1] = gl_MultiTexCoord0 * rtvasize;

  //  gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;

  vec4 np = vec4(1.0/uniform_xz_scale_inv * gl_Vertex.x+translate.x, 
		 (gl_Vertex.y+translate.y),
		 1.0/uniform_xz_scale_inv * gl_Vertex.z+translate.z, 
		 1.0);

  gl_Position = gl_ModelViewProjectionMatrix * np;
  
}


//void main(void)
void main_RINGS()
{

  //prior to rotation... disc in xy-plane, normal pointing towards
  //positive z
  //so distance from center = sqrt(dot(gl_Vertex.xy, gl_Vertex.xy))
  
  float dist_p2 = dot(gl_Vertex.xy,gl_Vertex.xy);

  dist_p2 = sqrt(dist_p2);

  gl_Position = ftransform();

  ipoled_height = gl_Vertex.z;

  vec3 t = vec3(2.0, cos(gl_Vertex.x), 0.0);
  vec3 bt = vec3(0.0, cos(gl_Vertex.y), 2.0);

  normal.xyz = normalize(cross(bt, t));

  height_diffs.x = cos(gl_Vertex.x); //for tangent
  height_diffs.y = sin(gl_Vertex.x)+sin(gl_Vertex.y); //for height-offset
  height_diffs.z = cos(gl_Vertex.y); //for bitangent


  height_diffs.y *= 10.0;
  ws_normal = vec4(gl_Normal.xyz, 1.0);  
}


