//#extension GL_ARB_texture_rectangle : enable

uniform sampler3D wave3D;

uniform float slice_nr;

uniform vec2 texLookupScale;
uniform float waveScale;
uniform float waveOff;


//varying vec2 tc;
varying vec3 normal;
varying vec4 vertexPos;

varying vec4 height_diffs;

varying float ipoled_height;

varying vec4 ws_normal;

uniform float uniform_xz_scale_inv;

uniform float ripple_scale;
uniform float ripple_scale_curr;
uniform float ripple_freq;

varying vec4 deltas;
varying vec2 deltac;


void main(void)
{
  vec2 spawnval;

  spawnval.x = deltas.x*ripple_freq;
  spawnval.y = deltas.y*ripple_freq;

  //  float z = sin(for_x) + sin(for_z);
  float len = length(spawnval);

  //  float damp = 1.0 - (1.0-len)*(1.0-len);
  float damp = (ripple_freq-len)/ripple_freq;
  
  //  damp *= damp; //damp^2
  //damp *= damp; //damp^4 -- faster falloff
  
  //
  damp = damp*damp*damp;
  //  damp = pow(damp, 3.0);

  float z = sin(len  + slice_nr*-10.0) * damp;
  z *= ripple_scale_curr;


  /**  
  float x_hp = sin(length(vec2(+uniform_xz_scale_inv+deltas.x, deltas.y)*ripple_freq) + slice_nr*-10.0);
float x_hm = sin(length(vec2(-uniform_xz_scale_inv+deltas.x, deltas.y)*ripple_freq) + slice_nr*-10.0);

float z_hp = sin(length(vec2(deltas.x, +uniform_xz_scale_inv+deltas.y)*ripple_freq) + slice_nr*-10.0);
  float z_hm = sin(length(vec2(deltas.x, -uniform_xz_scale_inv+deltas.y)*ripple_freq) + slice_nr*-10.0);
  
  float x_hdiff = x_hp - x_hm;
  float z_hdiff = z_hp - z_hm;

  vec3 dx = vec3(2.0, (x_hdiff)*ripple_scale*damp, 0.0);
  vec3 dz = vec3(0.0, (z_hdiff)*ripple_scale*damp, 2.0);


  vec3 normal = normalize(cross(dz, dx));
  //  normal.xz = clamp(normal.xz, -0.9, 0.9);
  **/


  //make z smaller, so that blending doesn't result in plateaus immediately..
  //
  z*=0.55;
  //  z*=0.6;


  
  //for unsigned tex
  z+=ripple_scale;
  //  z/=ripple_scale;
  //
  z/=2.0*ripple_scale;
  

  /**
  normal*=0.5;
  normal+=0.5;
  
  normal = clamp(normal, 0.0, 1.0);
  **/

  z = clamp(z, 0.0, 1.0);

  //also write normal ... problem, when blended!!!
  ///  gl_FragColor = vec4(normal.xyz, z);

    ///just write heightval as grayscale image
  gl_FragColor = vec4(z, z, z, z);

    ///    gl_FragColor = vec4(0.5, 0.5, 0.5, 0.5);
      
}



