uniform sampler2D noiseMap;

uniform float texW;
uniform float texH;

uniform vec4 trans;
uniform vec4 scale;

varying vec2 tc;
uniform vec2 texLookupScale;

//varying float vertex_height;
varying vec4 worldpos_vert;

varying vec4 shadow_tex_coord;

varying float vertex_height;

float ComputeCameraDepth(vec4 worldSpacePos)
{
  //vec4 viewPos = gl_ModelViewMatrix *  worldSpacePos;
vec4 viewPos = worldSpacePos;
  return viewPos.z;
}


void main() 
{
  //  tc = gl_Vertex.xz;
  tc = gl_Vertex.xz * texLookupScale;

  //  vec4 transformed_vertex = gl_Vertex; //(gl_Vertex+trans)*scale;

  //  vertex_height = (gl_Vertex.y+trans.y)*scale.y;
  //  vertex_height = transformed_vertex.y;

  worldpos_vert = gl_Vertex;

  gl_TexCoord[4].q = ComputeCameraDepth(worldpos_vert);

  //  shadow_tex_coord = gl_TextureMatrix[2] * worldpos_vert;

  //
  shadow_tex_coord = gl_TextureMatrix[2] * worldpos_vert;
  vertex_height = worldpos_vert.y;

  worldpos_vert.y *= 0.75; //scale AFTER proj shadow coord!



  gl_Position = gl_ModelViewProjectionMatrix * worldpos_vert;
  gl_ClipVertex = gl_ModelViewMatrix * worldpos_vert;

}
