uniform sampler2D noiseMap;

uniform float texW;
uniform float texH;

uniform vec4 camPos;

uniform vec4 trans;
uniform vec4 scale;

varying vec2 tc;

uniform vec2 texLookupScale;

varying float vertex_height;

varying vec4 shadow_tex_coord;

varying vec3 V;

void main() 
{
  //  tc = gl_Vertex.xz;
  tc = gl_Vertex.xz * texLookupScale;

  vec4 transformed_vertex = gl_Vertex; //(gl_Vertex+trans)*scale;

  //  vertex_height = (gl_Vertex.y+trans.y)*scale.y;
  vertex_height = transformed_vertex.y;

  V = transformed_vertex.xyz - camPos.xyz;
  V = normalize(V);

  shadow_tex_coord = gl_TextureMatrix[2] * transformed_vertex;

  gl_Position = gl_ModelViewProjectionMatrix * transformed_vertex;

  gl_ClipVertex = gl_ModelViewMatrix * transformed_vertex;

}
