varying vec4 shadow_tex_coord;
uniform sampler2DShadow shadowMap;

uniform float light_still_in_shadowed_region;

void main() 
{
  vec4 color;

      //approx color

color = gl_Color;


   // SM stable!!!
   // 0 ... if the object is in shadow 
   // 1 ... if it is not in shadow
   if(shadow_tex_coord.q > 0.0)
     {

       //shadow2DProj (shadowMap, shadowTexCoord) will return a vec4 that is 0 if the object is in shadow in 1 if it is not in shadow
   float in_shadow = shadow2DProj(shadowMap, shadow_tex_coord).x;

   //   color.rgb *= max(in_shadow, 0.8); //will still be 80% of original color, if in shadow!!!

   color.rgb *= max(in_shadow, light_still_in_shadowed_region);

   /*
   if(in_shadow >= 0.9)
     color.rgb=vec3(0.0, 0.0, 0.0);
   */

     }


   gl_FragColor = color;
   //gl_FragColor.a = 1.0;
    
}
