varying vec3 normal, view, light;

uniform sampler2D decalMap;
uniform sampler2D noiseMap;

varying vec4 shadow_tex_coord;
uniform sampler2DShadow shadowMap;

uniform float light_still_in_shadowed_region;

uniform float flame;

uniform vec4 global_light_dir;

//x ... d_focus
//y ... d_near
//z ... d_far
//w ... clamp_far
uniform vec4 dof_params; 

uniform int need_dof_alpha;


float ComputeDepthBlur(float depth)
{
  float f;

  if(depth < dof_params.x) // if(depth < d_focus)
    {
      // distance between near blur distance and
      // focal distance
      // map range to [-1, 0]

      // f = (depth - d_focus) / (d_focus - d_near);
      f = (depth - dof_params.x) / (dof_params.x - dof_params.y);
    }
  else
    {
      // distance between focal distance and
      // far blur distance
      // map range to [0, 1]

      // f = (depth - d_focus) / (d_far - d_focus);
      f = (depth - dof_params.x) / (dof_params.z - dof_params.x);
      f = clamp(f, 0.0, dof_params.w);
    }

  // scale and bias into [0, 1] range
  //
  return (f * 0.5 + 0.5);
  //  return depth;
}


void main() 
{
  vec4 color;

  float in_shadow=1.0;
      //approx color

  //color = gl_Color;
  color = texture2D(decalMap, gl_TexCoord[0].st);


   // SM stable!!!
   // 0 ... if the object is in shadow 
   // 1 ... if it is not in shadow
   if(shadow_tex_coord.q > 0.0)
     {

       //shadow2DProj (shadowMap, shadowTexCoord) will return a vec4 that is 0 if the object is in shadow in 1 if it is not in shadow
       //float in_shadow = shadow2DProj(shadowMap, shadow_tex_coord).x;
in_shadow = shadow2DProj(shadowMap, shadow_tex_coord).x;

   //   color.rgb *= max(in_shadow, 0.8); //will still be 80% of original color, if in shadow!!!

   color.rgb *= max(in_shadow, light_still_in_shadowed_region);

   /*
   if(in_shadow >= 0.9)
     color.rgb=vec3(0.0, 0.0, 0.0);
   */

     }


   gl_FragColor = color;
   //gl_FragColor.a = 1.0;

   vec4 final_color;

   if(flame > 0.0)
     {
// Fragmentnormale im Kamerakoordinatensystem
vec3 fragNormal = normalize(normal);
vec3 fragView = normalize(view);
vec3 fragLight = normalize(light);
// 
vec3 reflection = normalize(reflect(-light, normal));
//vec3 reflection = normalize(reflect(light, normal));

   //vec3 reflection = normalize(reflect(light, normal));
float NdotL = max(0.0, dot(fragNormal, fragLight));
float VdotR = dot(fragView, reflection);
//float VdotR = dot(-fragView, reflection);

// if(dot(fragNormal, fragLight) < 0.0) VdotR = 0.0;
//float VdotRExp = pow(max(0.0, VdotR), gl_FrontMaterial.shininess);
//
float VdotRExp = pow(max(0.0, VdotR), 20.0);
// float VdotRExp = min(pow(max(0.0, VdotR), 500.0), NdotL);

//
 if(NdotL <= 0.0) VdotRExp=0.0;

/*
final_color =
gl_FrontMaterial.ambient*
(gl_LightSource[0].ambient+gl_LightModel.ambient) +
  //NdotL * gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse +
NdotL * gl_LightSource[0].diffuse * color +
VdotRExp * gl_FrontMaterial.specular*gl_LightSource[0].specular;
*/
   vec4 fake_bump = texture2D(decalMap, gl_TexCoord[0].st);

   /*
   if(in_shadow > 0.5)
     {

final_color =
  
  //ambient
0.2 * color + 

  //diffuse
  //
  NdotL * 1.0 * color +
  //  NdotL * 1.0 * color * fake_bump+
  //  NdotL * vec4(1.0)
  
  //specular
  //  VdotRExp * 0.25 * vec4(1.0);
  //  VdotRExp * 0.25 * fake_bump;
  VdotRExp * 0.5 * fake_bump;
;
     }
   else
     {
final_color =
  //ambient
  0.2 * color;
     }
   */
final_color =
  //ambient
0.2 * color + 
  
  //diffuse
  NdotL * in_shadow * color +
  //specular
  VdotRExp * 0.5 * in_shadow * fake_bump;
	     
;




     }
   else final_color=color;

   gl_FragColor.xyz = final_color.xyz;

      if(need_dof_alpha==0)
	{
   //
	gl_FragColor.a = 1.0;
	}
      else
	{
   //gl_FragColor.a = ComputeDepthBlur(gl_TexCoord[4].q);


  gl_FragColor.a = gl_TexCoord[4].q / dof_params.z;
	}
   //   gl_FragColor.a = final_color.r;

//gl_FragColor = texture2D(decalMap, gl_TexCoord[0].st);
    
}
