uniform sampler2D noiseMap;

uniform float texW;
uniform float texH;

uniform vec4 trans;
uniform vec4 scale;

varying vec2 tc;

varying float vertex_height;

varying vec4 shadow_tex_coord;


void main() 
{
  tc = gl_Vertex.xz;

  vec4 transformed_vertex = (gl_Vertex+trans)*scale;

  //  vertex_height = (gl_Vertex.y+trans.y)*scale.y;
  vertex_height = transformed_vertex.y;

  shadow_tex_coord = gl_TextureMatrix[2] * transformed_vertex;

  gl_Position = gl_ModelViewProjectionMatrix * transformed_vertex;
  gl_ClipVertex = gl_ModelViewMatrix * transformed_vertex;

}
