//#extension GL_ARB_texture_rectangle : enable

//
uniform sampler2D cMap;
//uniform sampler2DRect cMap;

uniform sampler2D noiseMap;

uniform float texW;
uniform float texH;

varying vec2 tc;

varying vec4 shadow_tex_coord;
uniform sampler2DShadow shadowMap;



void main() 
{
  vec4 color;

  //
color = texture2D(cMap, tc*vec2(4.0/texW, 4.0/texH));
  //  color = texture2D(cMap, (tc+vec2(0.5, 0.5))*vec2(4.0/texW, 4.0/texH));

  //make color darker
  //  color *= 0.8;

  color += ((texture2D(noiseMap, tc.xy*vec2(256.0/texW, 256.0/texH)).rrra-vec4(0.5,0.5,0.5,0.0))*vec4(.35, .35, .35, 1.0));
  //
  color += ((texture2D(noiseMap, tc.xy*vec2(128.0/texW, 128.0/texH)).rrra-vec4(0.5,0.5,0.5,0.0))*vec4(.35, .35, .35, 1.0));

  color += ((texture2D(noiseMap, tc.xy*vec2(32.0/texW, 32.0/texH)).rrra-vec4(0.5,0.5,0.5,0.0))*vec4(.2, .2, .2, 1.0));

  //  color = texture2DRect(cMap, tc);


   // SM stable!!!
   // 0 ... if the object is in shadow 
   // 1 ... if it is not in shadow
   if(shadow_tex_coord.q > 0.0)
     {
   float in_shadow = shadow2DProj(shadowMap, shadow_tex_coord).x;

   //   color.rgb *= max(in_shadow, 0.8); //will still be 80% of original color, if in shadow!!!

   color.rgb *= max(in_shadow, 0.4);
     }



  gl_FragColor = color;
}
