varying vec3 normal;
varying vec3 lightDir;
uniform bool texturusing;
uniform bool particle;
uniform vec3 camview;
uniform vec3 campos;
uniform bool shader;
uniform bool not_shaded;
varying vec4 mycolor;
varying vec4 pos;
uniform float treshold[4];
uniform float value[5];
void main()
{	

	gl_FrontColor = gl_Color;
	gl_BackColor = gl_Color;
	gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;
	normal = normalize(gl_NormalMatrix * gl_Normal);
	vec4 diffuse, ambient;
	vec4 modview = gl_ModelViewMatrix * gl_Vertex;
	lightDir = normalize(vec3(gl_LightSource[0].position));
	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;	
	ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	ambient += gl_LightModel.ambient * gl_FrontMaterial.ambient;
	float NdotL = max(dot(normal, lightDir), 0.0);
	vec4 light = diffuse*NdotL;
	if(not_shaded)
		mycolor = gl_Color;
	else
		mycolor = light+ambient;
	pos=ftransform();

	gl_Position = pos;
}