// Diffuse GLSL Vertex Shader
// Written by Florian Rudolf (corrail@gmx.at)
// Copyright (c) 2004; All right reserved

#define ShadowProjTexAdjMatrix gl_TextureMatrix[7]
#define ShadowProjMatrix gl_TextureMatrix[6]
#define ObjectMatrix gl_TextureMatrix[5]
uniform float zFar, zNear;

attribute vec3 a2v_Normal;
attribute vec2 a2v_Texcoord;

varying vec3 v2f_Normal;
varying vec3 v2f_LightVec;
varying vec2 v2f_Texcoord;

varying vec2 v2f_ShadowTexcoord;
varying float v2f_Depth;

void main()
{
	// Vertex transformation
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;

	// Calculation Light vector in ModelView Space
	vec4 VertexObjectViewSpace = gl_ModelViewMatrix * gl_Vertex;
	v2f_LightVec = vec3(gl_LightSource[0].position - VertexObjectViewSpace);
	
	// Normal transformation
	v2f_Normal = gl_NormalMatrix * a2v_Normal;
	
	v2f_Texcoord = a2v_Texcoord;

	// Shadow Calculation
	vec4 Position = ShadowProjMatrix * gl_Vertex;
	v2f_Depth = (1.0-Position.z)*0.5;

	v2f_ShadowTexcoord = vec2(ShadowProjTexAdjMatrix * gl_Vertex);
}