// Diffuse GLSL Vertex Shader
// Written by Florian Rudolf (corrail@gmx.at)
// Copyright (c) 2004; All right reserved

uniform sampler2D BaseMap;
uniform sampler2D PathMap;
uniform sampler2D PathAlphaMap;
uniform sampler2D LogicMap;

uniform sampler2D ShadowMap;

varying vec3 v2f_Normal;
varying vec3 v2f_LightVec;
varying vec2 v2f_Texcoord;

varying vec2 v2f_ShadowTexcoord;
varying float v2f_Depth;

const vec2 TexelSize = vec2(1.0/1024.0, 1.0/512.0);

float OffsetLockup(vec2 loc, vec2 offset)
{ return texture2D(ShadowMap, loc + (offset-vec2(1.5)) * TexelSize).x; }

float ShadowPCF1X1(vec2 position)
{ return ((v2f_Depth - OffsetLockup(position, vec2(0.0, 0.0)).x) > 0.0) ? 1.0 : 0.0; }

float ShadowPCF2X2(vec2 position)
{
	vec4 Accum;
	Accum.x = v2f_Depth - OffsetLockup(position, vec2(0.0, 0.0));
	Accum.y = v2f_Depth - OffsetLockup(position, vec2(0.0, 1.0));
	Accum.z = v2f_Depth - OffsetLockup(position, vec2(1.0, 0.0));
	Accum.w = v2f_Depth - OffsetLockup(position, vec2(1.0, 1.0));

	Accum.x = (Accum.x > 0.0) ? 1.0 : 0.0;
	Accum.y = (Accum.y > 0.0) ? 1.0 : 0.0;
	Accum.z = (Accum.z > 0.0) ? 1.0 : 0.0;
	Accum.w = (Accum.w > 0.0) ? 1.0 : 0.0;

	return mix(mix(Accum.x, Accum.y, v2f_ShadowTexcoord.x),
		mix(Accum.z, Accum.w, v2f_ShadowTexcoord.x),
		v2f_ShadowTexcoord.y);
}

float ShadowPCF4X4(vec2 position)
{
vec4 row1;
	row1.x = v2f_Depth - OffsetLockup(position, vec2(0.0, 0.0));
	row1.y = v2f_Depth - OffsetLockup(position, vec2(1.0, 0.0));
	row1.z = v2f_Depth - OffsetLockup(position, vec2(2.0, 0.0));
	row1.w = v2f_Depth - OffsetLockup(position, vec2(3.0, 0.0));

	row1.x = (row1.x > 0.0) ? 1.0 : 0.0;
	row1.y = (row1.y > 0.0) ? 1.0 : 0.0;
	row1.z = (row1.z > 0.0) ? 1.0 : 0.0;
	row1.w = (row1.w > 0.0) ? 1.0 : 0.0;

	vec4 row2;
	row2.x = v2f_Depth - OffsetLockup(position, vec2(0.0, 1.0));
	row2.y = v2f_Depth - OffsetLockup(position, vec2(1.0, 1.0));
	row2.z = v2f_Depth - OffsetLockup(position, vec2(2.0, 1.0));
	row2.w = v2f_Depth - OffsetLockup(position, vec2(3.0, 1.0));

	row2.x = (row2.x > 0.0) ? 1.0 : 0.0;
	row2.y = (row2.y > 0.0) ? 1.0 : 0.0;
	row2.z = (row2.z > 0.0) ? 1.0 : 0.0;
	row2.w = (row2.w > 0.0) ? 1.0 : 0.0;

	vec4 row3;
	row3.x = v2f_Depth - OffsetLockup(position, vec2(0.0, 2.0));
	row3.y = v2f_Depth - OffsetLockup(position, vec2(1.0, 2.0));
	row3.z = v2f_Depth - OffsetLockup(position, vec2(2.0, 2.0));
	row3.w = v2f_Depth - OffsetLockup(position, vec2(3.0, 2.0));

	row3.x = (row3.x > 0.0) ? 1.0 : 0.0;
	row3.y = (row3.y > 0.0) ? 1.0 : 0.0;
	row3.z = (row3.z > 0.0) ? 1.0 : 0.0;
	row3.w = (row3.w > 0.0) ? 1.0 : 0.0;

	vec4 row4;
	row4.x = v2f_Depth - OffsetLockup(position, vec2(0.0, 3.0));
	row4.y = v2f_Depth - OffsetLockup(position, vec2(1.0, 3.0));
	row4.z = v2f_Depth - OffsetLockup(position, vec2(2.0, 3.0));
	row4.w = v2f_Depth - OffsetLockup(position, vec2(3.0, 3.0));

	row4.x = (row4.x > 0.0) ? 1.0 : 0.0;
	row4.y = (row4.y > 0.0) ? 1.0 : 0.0;
	row4.z = (row4.z > 0.0) ? 1.0 : 0.0;
	row4.w = (row4.w > 0.0) ? 1.0 : 0.0;

	return dot((row1 + row2 + row3 + row4) / 16.0, vec4(1.0));
}

float ShadowPCF4X4Jittered(vec2 position)
{
	vec4 row1;
	row1.x = v2f_Depth - OffsetLockup(position, 512.0*vec2(-0.000692, -0.000868));
	row1.y = v2f_Depth - OffsetLockup(position, 512.0*vec2(0.000450, -0.002347));
	row1.z = v2f_Depth - OffsetLockup(position, 512.0*vec2(0.000773, -0.002042));
	row1.w = v2f_Depth - OffsetLockup(position, 512.0*vec2(0.001880, -0.001592));

	row1.x = (row1.x > 0.0) ? 1.0 : 0.0;
	row1.y = (row1.y > 0.0) ? 1.0 : 0.0;
	row1.z = (row1.z > 0.0) ? 1.0 : 0.0;
	row1.w = (row1.w > 0.0) ? 1.0 : 0.0;

	vec4 row2;
	row2.x = v2f_Depth - OffsetLockup(position, 512.0*vec2(-0.001208, -0.001198));
	row2.y = v2f_Depth - OffsetLockup(position, 512.0*vec2(-0.000915, -0.000425));
	row2.z = v2f_Depth - OffsetLockup(position, 512.0*vec2(-0.000050, 0.000105));
	row2.w = v2f_Depth - OffsetLockup(position, 512.0*vec2(0.001719, -0.000753));

	row2.x = (row2.x > 0.0) ? 1.0 : 0.0;
	row2.y = (row2.y > 0.0) ? 1.0 : 0.0;
	row2.z = (row2.z > 0.0) ? 1.0 : 0.0;
	row2.w = (row2.w > 0.0) ? 1.0 : 0.0;

	vec4 row3;
	row3.x = v2f_Depth - OffsetLockup(position, 512.0*vec2(-0.001855, -0.000004));
	row3.y = v2f_Depth - OffsetLockup(position, 512.0*vec2(-0.001212, 0.001140));
	row3.z = v2f_Depth - OffsetLockup(position, 512.0*vec2(0.000684, 0.000273));
	row3.w = v2f_Depth - OffsetLockup(position, 512.0*vec2(0.000647, 0.000177));

	row3.x = (row3.x > 0.0) ? 1.0 : 0.0;
	row3.y = (row3.y > 0.0) ? 1.0 : 0.0;
	row3.z = (row3.z > 0.0) ? 1.0 : 0.0;
	row3.w = (row3.w > 0.0) ? 1.0 : 0.0;

	vec4 row4;
	row4.x = v2f_Depth - OffsetLockup(position, 512.0*vec2(-0.001448, 0.002095));
	row4.y = v2f_Depth - OffsetLockup(position, 512.0*vec2(0.000421, 0.000811));
	row4.z = v2f_Depth - OffsetLockup(position, 512.0*vec2(0.000542, 0.001491));
	row4.w = v2f_Depth - OffsetLockup(position, 512.0*vec2(0.002367, 0.000537));

	row4.x = (row4.x > 0.0) ? 1.0 : 0.0;
	row4.y = (row4.y > 0.0) ? 1.0 : 0.0;
	row4.z = (row4.z > 0.0) ? 1.0 : 0.0;
	row4.w = (row4.w > 0.0) ? 1.0 : 0.0;

	return dot((row1 + row2 + row3 + row4) / 16.0, vec4(1.0));
}

void main()
{
	// Define the Colors
	float PathAlpha = texture2D(PathAlphaMap, vec2(v2f_Texcoord.y,1.0-v2f_Texcoord.x)).x;
	vec4 Color = texture2D(BaseMap, v2f_Texcoord*30.0) * gl_LightSource[0].diffuse * (1.0-PathAlpha);
	Color += texture2D(PathMap, v2f_Texcoord*30.0) * gl_LightSource[0].diffuse * PathAlpha;

	// Normalize the interpolated Normal and Light Vector
	vec3 Normal = normalize(v2f_Normal);
	vec3 LightVec = normalize(v2f_LightVec);
	
	float DiffuseTerm = max(dot(LightVec, Normal), 0.0);

	float Result = ShadowPCF2X2(v2f_ShadowTexcoord);

	gl_FragColor = Color * (0.3 + DiffuseTerm*0.7*Result);// *
		//texture2D(LogicMap, vec2(v2f_Texcoord.y,1.0-v2f_Texcoord.x));
}