// Sky Dome GLSL Vertex Shader
// Written by Florian Rudolf (corrail@gmx.at)
// Copyright (c) 2004; All right reserved

attribute vec3 a2v_Normal;

varying vec4 v2f_Color;

void main()
{
	// Vertex transformation
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;	
	gl_Position.xyz -= gl_ModelViewProjectionMatrix[3].xyz;
	gl_Position.w = gl_Position.z;
	//gl_Position = gl_Vertex;
	
	const vec4 Kr = vec4(0.5, 0.25, 0.3, 0.0);
	const vec4 Km = vec4(0.01, 0.4, 0.8, 0.0);
	const vec3 sun_normal = vec3(0, 0.8944, -0.4472);
	const vec4 sun_color = vec4(0.50, 0.50, 1.00, 0.0);
	const float invR = 1.0 / 10.0;
	
	float theta = dot(a2v_Normal, sun_normal);
	
	float Fr = max(0.75 * theta * theta, 0.0) + 0.75;
	float Fm = (abs(theta) < 1.0) ? 0.75 : 1.75;
	float S = gl_Vertex.y * gl_Vertex.y * -1.0 * invR * invR + 3.0;

	v2f_Color = (Kr*Fr + Km*Fm) * S * sun_color * gl_LightSource[0].diffuse;
}