// Diffuse GLSL Vertex Shader
// Written by Florian Rudolf (corrail@gmx.at)
// Copyright (c) 2004; All right reserved

uniform sampler2D BaseMap;

varying vec3 v2f_Normal;
varying vec3 v2f_LightVec;
varying vec2 v2f_Texcoord;

void main()
{
	// Define the Colors
	vec4 Color = texture2D(BaseMap, v2f_Texcoord) * gl_LightSource[0].diffuse;

	// Normalize the interpolated Normal and Light Vector
	vec3 Normal = normalize(v2f_Normal);
	vec3 LightVec = normalize(v2f_LightVec);
	
	float DiffuseTerm = max(dot(LightVec, Normal), 0.0);

	// Calculating the final Color
	gl_FragColor = Color * vec4(0.3 + DiffuseTerm*0.7);
	//gl_FragColor.w = 0.7;
}