// Specular GLSL Vertex Shader
// Written by Florian Rudolf (corrail@gmx.at)
// Copyright (c) 2004; All right reserved

uniform mat4 matObjectViewProjection;
uniform mat4 matObjectView;
uniform mat3 matObjectViewIT;
uniform mat4 matObject;
uniform mat3 matObjectIT;
uniform mat4 matView;
uniform mat3 matViewIT;

uniform vec3 lightPosition0;

attribute vec3 a2v_Normal;
attribute vec2 a2v_Texcoord;

varying vec3 v2f_Normal;
varying vec3 v2f_LightVec;
varying vec3 v2f_ViewVec;
varying vec2 v2f_Texcoord;

void main()
{
	// Vertex transformation
	gl_Position = matObjectViewProjection * gl_Vertex;

	// Calculation Light vector in ModelView Space
	vec3 Vertex_ModelView = vec3(matObjectView * gl_Vertex);
	v2f_LightVec = lightPosition0 - Vertex_ModelView;
	v2f_ViewVec = -Vertex_ModelView;

	// Normal transformation
	v2f_Normal = matObjectViewIT * a2v_Normal;
	
	v2f_Texcoord = a2v_Texcoord;
}