// Specular GLSL Fragment Shader
// Written by Florian Rudolf (corrail@gmx.at)
// Copyright (c) 2004; All right reserved

uniform sampler2D BaseMap;

varying vec3 v2f_Normal;
varying vec3 v2f_LightVec;
varying vec3 v2f_ViewVec;
varying vec2 v2f_Texcoord;

void main()
{
	// Define the Colors
	vec4 Color = texture2D(BaseMap, v2f_Texcoord) * gl_LightSource[0].diffuse;

	// Normalize the interpolated Normal and Light Vector
	vec3 Normal = normalize(v2f_Normal);
	vec3 LightVec = normalize(v2f_LightVec);
	vec3 ViewVec = normalize(v2f_ViewVec);

	// Calculating Diffuse Term
	float DiffuseTerm = max(dot(Normal, LightVec), 0.0);

	// Calculating Specular Term (using Phong equation)
	vec3 Reflect = normalize(2.0 * DiffuseTerm * Normal - LightVec);
	vec4 Specular = vec4(pow(max(dot(Reflect, ViewVec), 0.0), 16.0));

	// Calculating the final Color
	gl_FragColor = Color * (1.0 + DiffuseTerm) + Specular;
}