// Diffuse GLSL Vertex Shader
// Written by Florian Rudolf (corrail@gmx.at)
// Copyright (c) 2004; All right reserved

#define ShadowProjTexAdjMatrix gl_TextureMatrix[7]
#define ShadowProjMatrix gl_TextureMatrix[6]
#define ObjectMatrix gl_TextureMatrix[5]
uniform float zFar, zNear;

varying vec2 v2f_Texcoord;

varying vec2 v2f_ShadowTexcoord;
varying float v2f_Depth;

void main()
{
	// Vertex transformation
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	
	v2f_Texcoord = vec2(gl_MultiTexCoord0);

	// Shadow Calculation
	vec4 VertexObjectSpace = gl_Vertex;
	vec4 Position = ShadowProjMatrix * VertexObjectSpace;
	v2f_Depth = (1.0-Position.z)*0.5 + 0.004;
	v2f_ShadowTexcoord = vec2(ShadowProjTexAdjMatrix * VertexObjectSpace);
}