#version 330 core

in vec3 position;
in vec3 normal;
in vec2 uv;

out VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
    vec4 FragPosLightSpace;
} vs_out;

uniform mat4 model;
uniform mat4 view_proj;
uniform mat4 lightSpaceMatrix;

void main() {
    gl_Position = view_proj * model * vec4(position, 1.0f);
    vs_out.FragPos = vec3(model * vec4(position, 1.0f));
    vs_out.Normal = transpose(inverse(mat3(model))) * normal;
    vs_out.TexCoords = uv;
    vs_out.FragPosLightSpace = lightSpaceMatrix * vec4(vs_out.FragPos, 1.0f);
}