#version 330 core

in vec2 texCoord;
in vec3 N;
in vec3 P;

out vec4 color; 

uniform vec3 light;
uniform sampler2D color_texture;
uniform vec3 cameraPos;

void main(){
    
    vec3 textureColor = texture(color_texture, texCoord).rgb;
    vec3 normal = normalize(N);

    vec3 ray = light-P;
    vec3 lightDirection = normalize(ray);



    float attenuation = 60/length(ray);

    attenuation = log(attenuation);
    
    if(attenuation < 0){
        attenuation = 0;
    }
    attenuation = sqrt(attenuation);



    float diffuse = max(0.0, dot(normal,lightDirection));



    float shininess = 200;

    float specular = 0;

    vec3 viewDirection = normalize(cameraPos - P);

    if (dot(normal, lightDirection) > 0.0) {

        specular = (60/length(ray)) * pow(max(0.0, dot(reflect(-lightDirection, normal),
        viewDirection)), shininess);

    }
    
    

    color = vec4(((diffuse*(attenuation*0.7)+0.3f)*textureColor + vec3(1, 1, 1)*specular), 1.0);
}