#version 330 core

in vec3 position;
in vec3 normal;
in vec3 tangent;
in vec2 uv;

out vec2 texCoord;
out vec3 N;
out vec3 P;
out vec4 ShadowCoord;
out vec4 LightSpacePos;
out vec3 Normal0;
out vec3 Tangent0;
out float hasTangent;

uniform mat4 MVP;
uniform mat4 Model;
uniform vec3 light;
uniform mat4 depthVP;

void main(){
	texCoord = uv;
	gl_Position = vec4(MVP*vec4(position, 1));
	
	ShadowCoord =  depthVP * Model * vec4(position, 1);

	mat4 normalMatrix = inverse(transpose(Model));
	vec3 worldNormal = normalize( (normalMatrix * vec4(normal, 0)).xyz );

	N = normalize(worldNormal);
	P = ( Model * vec4(position, 1) ).xyz;
	
	LightSpacePos = vec4(light, 1) * vec4(position, 1.0);
	Normal0 = normal;
	Tangent0 = tangent;
	if(tangent==vec3(0,0,1)){
		hasTangent = 0;
	}else{
		hasTangent=1;
	}
}