#version 330 core

in vec2 texCoord;
in vec3 N;
in vec3 P;

out vec4 color; 

uniform vec3 light;
uniform sampler2D color_texture;

void main(){   
    
    vec3 textureColor = texture(color_texture, texCoord).rgb;
    vec3 normal = normalize(N);

    vec3 ray = light-P;
    vec3 lightDirection = normalize(ray);

    float attenuation = 60/length(ray);

    float diffuse = max(0.0, dot(normal,lightDirection));
    
    attenuation = log(attenuation);
    
    if(attenuation < 0){
        attenuation = 0;
    }
    attenuation = sqrt(attenuation);
    color = vec4(((diffuse*(attenuation*0.7)+0.3f)*textureColor), 1.0);
}