#version 330 core

in vec3 position;
in vec2 uv;
in vec3 normal;
in vec3 tangent;

uniform mat4 MVP;
uniform vec3 light;
uniform mat4 Model;

out vec4 LightSpacePos;
out vec2 TexCoord0;
out vec3 Normal0;
out vec3 Tangent0;
out vec3 P;
out float hasTangent;

void main()
{
    gl_Position = MVP * vec4(position, 1.0);
	P = ( Model * vec4(position, 1) ).xyz;
    LightSpacePos = vec4(light, 1) * vec4(position, 1.0);
    TexCoord0 = uv;
    Normal0 = normal;
    Tangent0 = tangent;
	if(tangent==vec3(0,0,1)){
		hasTangent = 0;
	}else{
		hasTangent=1;
	}
}