#version 330 core

in vec4 LightSpacePos;
in vec2 TexCoord0;
in vec3 Normal0;
in vec3 Tangent0;
in vec3 P;
in float hasTangent;

out vec4 color;

uniform sampler2D color_texture;
uniform sampler2D normal_texture;
uniform vec3 light;
uniform vec3 cameraPos;

vec3 CalcBumpedNormal()
{
    vec3 Normal = normalize(Normal0);
    vec3 Tangent = normalize(Tangent0);
    Tangent = normalize(Tangent - dot(Tangent, Normal) * Normal);
    vec3 Bitangent = -cross(Tangent, Normal);
    vec3 BumpMapNormal = texture(normal_texture, TexCoord0).xyz;
    BumpMapNormal = 2.0 * BumpMapNormal - vec3(1.0, 1.0, 1.0);
    vec3 NewNormal;
    mat3 TBN = mat3(Tangent, Bitangent, Normal);
    NewNormal = TBN * BumpMapNormal;
    NewNormal = normalize(NewNormal);
    return NewNormal;
}

void main()
{	
	vec3 normal = CalcBumpedNormal();
	
	vec3 c = texture(color_texture, TexCoord0).rgb;
	
	vec3 ray = light-P;
    vec3 lightDirection = normalize(ray);
 	float diffuse = max(0.0, dot(normal,lightDirection));
	
	color = vec4((diffuse*0.7+0.3)*c, 1);	
}