#version 330 core

in vec2 texCoord;

out vec4 color; 

uniform float time;

void main(){
	
	vec2 z = vec2(0.0, 0.0);
	
	float t = fract(time);
	float scale = exp2(-2*t);
	
	t = (scale-0.25)/0.75;
	
	vec2 center = vec2(-1, 0)*(t) + (1-t)*vec2(-1.31, 0);
	
	scale = t*0.5*2 + (1-t)*0.115*2;
	
	
	
	//float scale = (1-t)*0.5*2 + t*0.12*2;
	
	//vec2 c = texCoord*3.0 + vec2(-2.0, -1.5);
	vec2 c = scale*(texCoord-vec2(0.5, 0.5))+center;
	
	int iterations = 90;
	for (int i=0; i<iterations; i++) {
		if (length(z) >= 2) {
			if (i%2 == 0) {
				color = vec4(1.0, 0.0, 0.0, 1.0);
			}else{
				color = vec4(1.0, 0.0, 0.0, 1.0);
				//color =vec4(0.0, 0.0, 0.0, 1.0);
			}
			return;
		}
		z = vec2((z.x*z.x-z.y*z.y), (2*z.x*z.y)) + c;
	}	
}