#version 330 core

in vec3 position;
in vec3 normal;
in vec2 uv;

out vec2 texCoord;
out vec3 N;
out vec3 P;

uniform mat4 MVP;
uniform mat4 Model;

void main(){
	texCoord = uv;
	gl_Position = vec4(MVP*vec4(position, 1));

	mat4 normalMatrix = inverse(transpose(Model));
	vec3 worldNormal = normalize( (normalMatrix * vec4(normal, 0)).xyz );

	N = normalize(worldNormal);
	P = ( Model * vec4(position, 1) ).xyz;
}