#version 330 core

in vec2 texCoord;
in vec3 N;
in vec3 P;

out vec4 color; 
uniform float time;
uniform vec3 light;
uniform sampler2D color_texture;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main(){   
    float r = rand(vec2(texCoord.x+time, texCoord.y+time));
	vec2 tex = vec2(texCoord.x*r, texCoord.y*r);
	tex = vec2(fract(time), fract((texCoord.x+texCoord.y)/2));
	if(tex.x>1){tex.x-1;}
	if(tex.y>1){tex.y-1;}
    vec3 textureColor = texture(color_texture, tex).rgb;
    vec3 normal = normalize(N);

    vec3 ray = light-P;
    vec3 lightDirection = normalize(ray);

    float attenuation = 60/length(ray);

    float diffuse = max(0.0, dot(normal,lightDirection));
    
    attenuation = log(attenuation);
    
    if(attenuation < 0){
        attenuation = 0;
    }
    attenuation = sqrt(attenuation);
    color = vec4(((diffuse*(attenuation*0.7)+0.3f)*textureColor), 1.0);
}