#version 330 core
in vec2 texCoord;

out vec4 color;

uniform float time;


float rand(vec3 co){
    return fract(sin(dot(co,vec3(12.9898, 78.233, 16.1803))) * 43758.5453);	
}

float rand2(vec2 co){
    return fract(sin(dot(co,vec2(12.9898, 78.233))) * 43758.5453);	
}

float gradient(vec3 inp){
	float x = inp.x * 16;
	float xF = floor(x);
	
	float y = inp.y * 16;
	float yF = floor(y);
	
	float z = inp.z * 16;
	float zF = floor(z);
		
	float v8 = rand(vec3(xF, yF, zF));
	
	return v8;	
}

void main()
{   	
	float c = gradient(vec3(texCoord, time));
    color = vec4(c, c, c, 1);
}

