#version 330 core

in vec2 uv;

out vec4 color; 

uniform float threshold;
uniform vec2 uShift;
uniform sampler2D color_texture;

void main(){
	const int gaussRadius = 11;
	float gaussFilter[gaussRadius] = float[gaussRadius](
		0.0402,0.0623,0.0877,0.1120,0.1297,0.1362,0.1297,0.1120,0.0877,0.0623,0.0402
	);
	
	vec2 texCoord = uv - float(int(gaussRadius/2)) * uShift;
	vec3 c = vec3(0.0, 0.0, 0.0);
	vec3 ch;
	for (int i=0; i<gaussRadius; ++i) { 
		ch = texture(color_texture, texCoord).rgb;
		if((ch.r+ch.g+ch.b)/3 > threshold){
			c += gaussFilter[i]* 2 * ch;		
		}
		texCoord = texCoord+uShift;
	}	
	color = vec4(c, 1);  
}