#version 330 core

in vec2 texCoord;

out vec4 color; 

uniform float time;
uniform sampler2D color_texture;

float rand(vec3 co){
    return fract(sin(dot(co,vec3(12.9898, 78.233, 16.1803))) * 43758.5453);	
}

float getW(float w){
    return (1 - cos(w*3.14159265359)) / 2;
}

float gradient(vec3 inp){
	float x = inp.x * 16;
	float xF = floor(x);
	float xC = ceil(x);
	
	float y = inp.y * 16;
	float yF = floor(y);
	float yC = ceil(y);
	
	float z = inp.z * 16;
	float zF = floor(z);
	float zC = ceil(z);
	
	float q1 = rand(vec3(xF, yF, zF));
	float q2 = rand(vec3(xC, yF, zF));
	float q3 = rand(vec3(xF, yC, zF));
	float q4 = rand(vec3(xC, yC, zF));
	float q5 = rand(vec3(xF, yF, zC));
	float q6 = rand(vec3(xC, yF, zC));
	float q7 = rand(vec3(xF, yC, zC));
	float q8 = rand(vec3(xC, yC, zC));
	
	float w = x - xF;
	w = getW(w);
	
	float l1 =(1 - w)*q1 + w*q2;
	float l2 =(1 - w)*q3 + w*q4;
	float l3 =(1 - w)*q5 + w*q6;
	float l4 =(1 - w)*q7 + w*q8;
	
	w = y - yF;
	w = getW(w);
	
	float k1 = (1 - w)*l1 + w*l2;
	float k2 = (1 - w)*l3 + w*l4;
	
	w = z - zF;
	w = getW(w);
	
	return (1 - w)*k1 + w*k2;
}

void main(){ 
    vec3 texColor = texture(color_texture, texCoord).rgb;
	
	vec2 uv = texCoord*5;
	
	uv = uv / 3 + vec2(-1, -1);
	
	float c1 = gradient(vec3(vec2(uv.x + sin(time/10), uv.y + cos(time/10)), time/10 + sin(uv.x)));
	
	uv = texCoord*5;
	
	float c2 = gradient(vec3(vec2(uv.x + sin(time/10), uv.y + cos(time/10)), time/10 + sin(uv.x)));
	
	uv = uv * 3 + vec2(1, 1);
	
	float c3 = gradient(vec3(vec2(uv.x + sin(time/10), uv.y + cos(time/10)), time/10 + sin(uv.x)));
	
	float c = 0.5*c1 + 0.3*c2 + 0.2*c3;
	  
    color = vec4((texColor*1.5f*c), 1.0);
}