#version 410 core

layout (location = 1) in vec3 position;
layout (location = 2) in vec3 normal;
layout (location = 3) in vec2 uv;

out vec3 worldNormal;
out vec2 texCoord;

uniform mat4 model;
uniform mat4 view_proj;

void main(){
	
	gl_Position = view_proj * model * vec4(position, 1);
	texCoord = uv;
	worldNormal = (model * vec4(normal, 0)).xyz;
}