#version 410 core

// Inspired by opengl tutorial 11 - http://www.opengl-tutorial.org/intermediate-tutorials/tutorial-11-2d-text/

// Input vertex data, different for all executions of this shader.
layout(location = 1) in vec2 vertexPosition_screenspace;
layout(location = 2) in vec2 vertexUV;

uniform vec2 half_window_size;

// Output data ; will be interpolated for each fragment.
out vec2 UV;

void main(){

	// Output position of the vertex, in clip space
	// map [0..window_width][0..window_height] to [-1..1][-1..1]
	vec2 vertexPosition_homoneneousspace = vertexPosition_screenspace - half_window_size; // [0..window_width][0..window_height] -> [-window_width/2..window_width][-window_height/2..window_height/2]
	vertexPosition_homoneneousspace /= half_window_size;
	gl_Position =  vec4(vertexPosition_homoneneousspace, 0, 1);
	
	// UV of the vertex. No special space for this one.
	UV = vertexUV;
}