#version 410 core
 
layout(location = 0) out vec4 outColor;

in vec2 uv;

uniform sampler2D textureSampler_color;
uniform sampler2D textureSampler_glow_texture;
uniform sampler2D textureSampler_glow_texture_unblurred;

float glow_intensity = 2.0f;

void main(){

	// outColor = texture2D(textureSampler_glow_texture, uv);

		vec4 glow = texture2D(textureSampler_glow_texture, uv);
		vec4 col = texture2D(textureSampler_color, uv);
		vec4 col_unblurred = texture2D(textureSampler_glow_texture_unblurred, uv);

		// Max col+col because gaussian filter will make objekts
		// centers brighter than object borders.. this just means
		// that the whole object should glow
		vec3 outColorRaw = max(col + glow * glow_intensity, col_unblurred + col_unblurred).rgb;

		//
		vec3 spillover = max(vec3(0,0,0), outColorRaw - vec3(1,1,1));
		outColorRaw.r += spillover.g / 2 + spillover.b / 2;
		outColorRaw.g += spillover.r / 2 + spillover.b / 2;
		outColorRaw.b += spillover.r / 2 + spillover.g / 2;

		outColor = vec4(clamp( outColorRaw, 0, 1), 1);
}