#version 410

layout(location = 0) out vec4 outColor;

in vec2 uv;

uniform sampler2D textureSampler_color;
uniform float resolution;

float blurSize = 3.0f / resolution; // 1/ texturesize

const int numBlurPixelsPerSide = 31;
const vec2  blurMultiplyVec = vec2(1.0f, 0.0f);

const float kernel[32] = float[32](
    0.0068,
    0.0073,
    0.0079,
    0.0085,
    0.0091,
    0.0097,
    0.0103,
    0.0110,
    0.0116,
    0.0123,
    0.0130,
    0.0137,
    0.0144,
    0.0150,
    0.0157,
    0.0164,
    0.0170,
    0.0176,
    0.0183,
    0.0188,
    0.0194,
    0.0199,
    0.0204,
    0.0208,
    0.0212,
    0.0216,
    0.0219,
    0.0221,
    0.0223,
    0.0224,
    0.0225,
    0.0225
);

void main(){
 
	vec4 avgValue = vec4(0.0f, 0.0f, 0.0f, 0.0f);
	avgValue += texture2D(textureSampler_color, uv) * kernel[numBlurPixelsPerSide];
	
	for (int i = 1; i <= numBlurPixelsPerSide; i++) {

		int k = numBlurPixelsPerSide - i;
		avgValue += texture2D(textureSampler_color, uv - i * blurSize * blurMultiplyVec) * kernel[k];         
		avgValue += texture2D(textureSampler_color, uv + i * blurSize * blurMultiplyVec) * kernel[k];          
	}
	
	outColor = avgValue;
}