#version 410 core

layout (location = 1) in vec3 position;
layout (location = 2) in vec3 normal;
layout (location = 3) in vec2 uv;

uniform mat4 MVP;
uniform mat4 M;
uniform mat4 V;

out vec2 texCoord;
out vec3 normal_vec;
out vec3 world_position;

void main(){
	
	normal_vec = (M * vec4(normal, 0.0)).xyz;

	// positions
	gl_Position = MVP * vec4(position, 1.0);

	world_position = (M  * vec4(position, 1.0)).xyz;

	// uvs
	texCoord = uv;
}