#version 410 core
 
// layout(location = 0) states, that out should go to
// standard back-buffer (usually and only if it's bound!)
// In theory, we could render into multiple buffers at
// the same time. Thus we have to specify the target.

layout(location = 0) out vec4 position;
layout(location = 1) out vec4 color;
layout(location = 2) out vec4 normals;
layout(location = 3) out vec4 glow_texture;

uniform sampler2D texture_diffuse1;
uniform int glows;

in vec2 texCoord;
in vec3 world_position;
in vec3 normal_vec;


void main(){

	position = vec4(world_position, 1);
	color = texture(texture_diffuse1, texCoord);
	normals = vec4(normal_vec, 1);
	
	if(glows == 1){
		
		glow_texture = color;
	}
	else{
	
		glow_texture = vec4(0,0,0,1);
	}	
}