#version 410

layout(location = 0) out vec4 outColor;

in vec2 uv;

uniform sampler2D color_texture;


const float sigma = 4.0f; 
const float blurSize = 1.0f / 12.0f; // 1/ texturesize

const int numBlurPixelsPerSide = 2;
const vec2  blurMultiplyVec = vec2(0.0f, 1.0f);
//uniform vec2  blurMultiplyVec;


const float kernel[5] = float[5](0.061, 0.242, 0.383, 0.242, 0.061);

void main(){
 
	vec4 avgValue = vec4(0.0f, 0.0f, 0.0f, 0.0f);
	avgValue += texture2D(color_texture, uv) * kernel[numBlurPixelsPerSide];

	for (int i = 1; i <= numBlurPixelsPerSide; i++) {

		int k = numBlurPixelsPerSide - i;
		avgValue += texture2D(color_texture, uv - i * blurSize * blurMultiplyVec) * kernel[k];         
		avgValue += texture2D(color_texture, uv + i * blurSize * blurMultiplyVec) * kernel[k];          
	}

	outColor = avgValue;

}