#version 410 core
 
// layout(location = 0) states, that out should go to
// standard back-buffer (usually and only if it's bound!)
// In theory, we could render into multiple buffers at
// the same time. Thus we have to specify the target.
layout(location = 0) out vec4 outColor;

in vec3 worldNormal;
in vec2 texCoord;

uniform sampler2D texture_diffuse1;
uniform sampler2D texture_specular1;
float shininess;

void main(){

	outColor = vec4(texture(texture_diffuse1, texCoord).rgb, 1.0);
}