#version 330 core

in vec2 fragmentUV;
out vec4 fragColor;

uniform sampler2D scene;
uniform sampler2D glow;
uniform sampler2D hud;
uniform bool glowing;
uniform bool gameEnded;

void main() {

	vec4 v1 = texture(scene, fragmentUV).rgba; // rendered scene
	vec4 v2 = texture(glow, fragmentUV).rgba; // glowmap
	vec4 v3 = texture(hud, fragmentUV).rgba; // hud

	float f = 0.3;
	if(gameEnded) {
		v1.r = max(v1.r-f, 0.0);
		v1.g = max(v1.g-f, 0.0);
		v1.b = max(v1.b-f, 0.0);

		v2.r = max(v2.r-f, 0.0);
		v2.g = max(v2.g-f, 0.0);
		v2.b = max(v2.b-f, 0.0);
	}

	// Additive blending (strong result, high overexposure)
	if(glowing == true) {
		fragColor = min(v1 + v2 + v3, 1.0);
	} else {
		fragColor = min(v1 + v3, 1.0);
	}
}