
#version 330 core

in vec2 fragmentUV;
out vec4 fragColor;

uniform sampler2D colorTexture;

/// <summary>
/// Gets the Gaussian value in the first dimension.
/// </summary>
/// <param name="x">Distance from origin on the x-axis.</param>
/// <param name="deviation">Standard deviation.</param>
/// <returns>The gaussian value on the x-axis.</returns>
float Gaussian (float x, float deviation)
{
	return (1.0 / sqrt(2.0 * 3.141592 * deviation)) * exp(-((x * x) / (2.0 * deviation)));	
}

void main()
{
	// Locals
	int BlurAmount = 10;
	float BlurScale = 1.1;
	float BlurStrength = 0.2;
	vec2 TexelSize = vec2(1.0/128.0, 1.0/128.0);
	float halfBlur = float(BlurAmount) * 0.5;
	vec4 colour = vec4(0.0);
	vec4 texColour = vec4(0.0);
	
	// Gaussian deviation
	float deviation = halfBlur * 0.35;
	deviation *= deviation;
	float strength = 1.0 - BlurStrength;

	// Horizontal blur
		for (int i = 0; i < BlurAmount; ++i)
		{
			float offset = float(i) - halfBlur;
			texColour = texture(colorTexture, fragmentUV + vec2(offset * TexelSize.x * BlurScale, 0.0)) * Gaussian(offset * strength, deviation);
			colour += texColour;
		}

		// Vertical blur
		for (int i = 0; i < BlurAmount; ++i)
		{
			float offset = float(i) - halfBlur;
			texColour = texture(colorTexture, fragmentUV + vec2(0.0, offset * TexelSize.y * BlurScale)) * Gaussian(offset * strength, deviation);
			colour += texColour;
		}

		fragColor = clamp(colour, 0.0, 1.0);
		fragColor.w = 1.0;
}
